/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.entity.Button;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class AdventureMenuState
extends GameState {
    private Mouse mouse;
    private ArrayList<Button> buttons;

    public AdventureMenuState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.mouse = new Mouse();
        this.buttons = new ArrayList();
        PlayerSave.setMode(1);
        PlayerSave.setTimeLimit(0.0);
        Button b0 = new Button(12, "World-1", 120, 120, 100, 100, 128, 190, true);
        this.buttons.add(b0);
        Button b1 = new Button(12, "World-2", 120, 120, 100, 100, 320, 190, true);
        if (PlayerSave.getTotalStars() < 20) {
            b1.setGreyed(true);
        }
        this.buttons.add(b1);
        Button b2 = new Button(12, "World-3", 120, 120, 100, 100, 512, 190, true);
        b2.setGreyed(true);
        this.buttons.add(b2);
        Button b3 = new Button(12, "World-4", 120, 120, 100, 100, 128, 315, true);
        b3.setGreyed(true);
        this.buttons.add(b3);
        Button b4 = new Button(12, "World-5", 120, 120, 100, 100, 320, 315, true);
        b4.setGreyed(true);
        this.buttons.add(b4);
        Button b5 = new Button(12, "World-6", 120, 120, 100, 100, 512, 315, true);
        b5.setGreyed(true);
        this.buttons.add(b5);
        Button b6 = new Button(14, "BACK", 180, 44, 320, 430, true);
        this.buttons.add(b6);
    }

    @Override
    public void update() {
        this.handleInput();
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.update();
            if (!b.getGreyed()) {
                if (b.intersects(this.mouse)) {
                    b.setHover(true);
                    if (this.mouse.getClicked()) {
                        if (b.getButtonID() == "World-1") {
                            PlayerSave.setWorld(1);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "World-2") {
                            PlayerSave.setWorld(2);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "World-3") {
                            PlayerSave.setWorld(3);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "World-4") {
                            PlayerSave.setWorld(4);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "World-5") {
                            PlayerSave.setWorld(5);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "World-6") {
                            PlayerSave.setWorld(6);
                            this.gsm.setState(4);
                        } else if (b.getButtonID() == "BACK") {
                            this.gsm.setState(0);
                        }
                    }
                } else {
                    b.setHover(false);
                }
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.Adventure, 320 - Content.Adventure.getWidth() / 2, 40, null);
        g.setColor(Color.WHITE);
        g.setFont(this.gsm.pixelFont22);
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.draw(g);
            ++i;
        }
        g.setFont(this.gsm.pixelFont14);
        g.drawImage((Image)Content.StarS[0], 100, 210, null);
        g.drawImage((Image)Content.StarS[0], 290, 210, null);
        g.drawString("x 0", 125, 225);
        g.drawString("x 20", 315, 225);
        this.gsm.drawCenteredString("Coming Soon", 128, 350, g);
        this.gsm.drawCenteredString("Coming Soon", 321, 350, g);
        this.gsm.drawCenteredString("Coming Soon", 514, 350, g);
        this.gsm.drawCenteredString("Coming Soon", 514, 225, g);
        this.mouse.draw(g);
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
    }
}

